-- Generated by SceneGenEditor and loaded by scenegen_autogen.lua
local t = {
  __displayName="treemon_forest",
  biome="forest",
  creature_spawners={
    battlefield={
      {
        color={ brightness=0, hue=0, saturation=0,},
        prop="spawner_plant1",
        sole_occupant_radius=2.0,
      },
    },
    miniboss={
      {
        color={ brightness=0, hue=0, saturation=0,},
        prop="spawner_miniboss",
        sole_occupant_radius=2.0,
      },
    },
    perimeter={
      {
        color={ brightness=0, hue=0, saturation=0,},
        prop="spawner_forest_perimeter",
        sole_occupant_radius=1.0,
      },
    },
  },
  destructibles={
    {
      dungeon_progress_constraints={
        midway={ easing="inCubic", likelihood={ from=0, to=1,},},
        near_boss={ easing="linear", likelihood={ from=1, to=1,},},
        start_run={ easing="linear", likelihood={ from=0, to=0,},},
      },
      prop="destructible_megatreemon_shorty",
    },
    {
      dungeon_progress_constraints={
        midway={ easing="inCubic", likelihood={ from=0, to=1.0,},},
        near_boss={ easing="linear", likelihood={ from=1, to=1,},},
        start_run={ easing="linear", likelihood={ from=0, to=0,},},
      },
      prop="destructible_megatreemon_tall",
    },
    {
      dungeon_progress_constraints={
        midway={ easing="outCubic", likelihood={ from=1, to=0.0,},},
        near_boss={ easing="linear", likelihood={ from=0, to=0,},},
        start_run={ easing="linear", likelihood={ from=1, to=1,},},
      },
      prop="destructible_wood_shorty",
    },
    {
      dungeon_progress_constraints={
        midway={ easing="outCubic", likelihood={ from=1, to=0,},},
        near_boss={ easing="linear", likelihood={ from=0, to=0,},},
        start_run={ easing="linear", likelihood={ from=1, to=1,},},
      },
      prop="destructible_wood_tall",
    },
  },
  dungeon="treemon_forest",
  environments={
    {
      label="Default",
      lighting={
        ambient="DFC6D4FF",
        clifflightdirection={ 0.050000000745058, -1.2000000476837, 0.40000000596046,},
        clifflightweight=0.46200001239777,
        clifframp="ramp_toni",
        colorcube={ boss="startingforest_boss_cc", entrance="startingforest_cc",},
        ground_shadow_strength=0.75,
        rimlightcolor="FFA6BAFF",
        rimlightpos={ 30.0, 50.0, 50.0,},
      },
      room_types={ "miniboss", "monster", "empty", "entrance", "boss", "insert", "hype",},
      sky={
        backgroundGradientCurve={
          boss={
            { 0.010928961748634, 0.59663867950439, 0.33516415953636, 0.30584001541138,},
            { 0.067395264116576, 0.4453781247139, 0.19836167991161, 0.36027163267136,},
            { 0.17486338797814, 0.16402590274811, 0.12880444526672, 0.31932771205902,},
            { 0.25764895330113, 0.14596797525883, 0.12811200320721, 0.2039999961853,},
            { 0.30434782608696, 0.077421889828939, 0.067950895300935, 0.10820175455728,},
            {
              0.32850241545894,
              9.9999999747524e-07,
              6.0349378827596e-07,
              3.1512607279183e-07,
            },
          },
          entrance={
            { 0, 0.81927710771561, 0.56426787376404, 0.25006049871445,},
            { 0.089253187613843, 0.45378148555756, 0.24329252541065, 0.22689074277878,},
            { 0.16898954703833, 0.34117648005486, 0.18823529779911, 0.31303530931473,},
            { 0.25442834138486, 0.15239617228508, 0.12811200320721, 0.2039999961853,},
            { 0.29468599033816, 0.086875610970527, 0.073031972165846, 0.11629266654636,},
            {
              0.31400966183575,
              9.9999999747524e-07,
              6.0349378827596e-07,
              3.1512607279183e-07,
            },
          },
        },
      },
      water={  },
    },
    {
      label="Shop rooms",
      lighting={
        ambient="DFC6D4FF",
        clifflightdirection={ 0.050000000745058, -1.2000000476837, 0.40000000596046,},
        clifflightweight=0.46200001239777,
        clifframp="ramp_toni",
        colorcube={ boss="startingforest_shop_boss_cc", entrance="startingforest_shop_cc",},
        ground_shadow_strength=0.75,
        rimlightcolor="FFA6C4FF",
        rimlightpos={ 30.0, 50.0, 50.0,},
      },
      room_types={ "mystery", "potion", "powerupgrade", "ranger", "resource", "wanderer", "food",},
      sky={
        backgroundGradientCurve={
          boss={
            { 0, 0.90336132049561, 0.66605424880981, 0.44788500666618,},
            { 0.079928952042629, 0.60408163070679, 0.31067052483559, 0.40408310294151,},
            { 0.13499111900533, 0.31428569555283, 0.14623905718327, 0.30674082040787,},
            { 0.2202486678508, 0.092111632227898, 0.11219014972448, 0.23265308141708,},
            {
              0.39890710382514,
              9.9999999747524e-07,
              6.0349378827596e-07,
              3.1512607279183e-07,
            },
          },
          entrance={
            { 0, 0.90336132049561, 0.66605424880981, 0.44788500666618,},
            { 0.091074681238616, 0.68487393856049, 0.40286698937416, 0.4384146630764,},
            { 0.17668488160291, 0.34117648005486, 0.18823529779911, 0.30776077508926,},
            { 0.26593806921676, 0.14010308682919, 0.15850374102592, 0.26890754699707,},
            {
              0.39890710382514,
              9.9999999747524e-07,
              6.0349378827596e-07,
              3.1512607279183e-07,
            },
          },
        },
      },
      water={  },
    },
    {
      label="NPC rooms",
      lighting={
        ambient="C8BFCEFF",
        clifflightdirection={ 0.050000000745058, -1.2000000476837, 0.40000000596046,},
        clifflightweight=0.46200001239777,
        clifframp="ramp_toni",
        colorcube={ boss="startingforest_shop_boss_cc", entrance="startingforest_shop_cc",},
        ground_shadow_strength=0.75,
        rimlightcolor="FFA6F2FF",
        rimlightpos={ 30.0, 50.0, 50.0,},
      },
      room_types={ "quest",},
      sky={
        backgroundGradientCurve={
          boss={
            { 0.010928961748634, 0.59663867950439, 0.33516415953636, 0.30584001541138,},
            { 0.067395264116576, 0.4453781247139, 0.19836167991161, 0.36027163267136,},
            { 0.17486338797814, 0.16402590274811, 0.12880444526672, 0.31932771205902,},
            { 0.25764895330113, 0.14596797525883, 0.12811200320721, 0.2039999961853,},
            { 0.30434782608696, 0.077421889828939, 0.067950895300935, 0.10820175455728,},
            {
              0.32850241545894,
              9.9999999747524e-07,
              6.0349378827596e-07,
              3.1512607279183e-07,
            },
          },
          entrance={
            { 0, 0.81927710771561, 0.56426787376404, 0.25006049871445,},
            { 0.089253187613843, 0.45378148555756, 0.24329252541065, 0.22689074277878,},
            { 0.16898954703833, 0.34117648005486, 0.18823529779911, 0.31303530931473,},
            { 0.25442834138486, 0.15239617228508, 0.12811200320721, 0.2039999961853,},
            { 0.29468599033816, 0.086875610970527, 0.073031972165846, 0.11629266654636,},
            {
              0.31400966183575,
              9.9999999747524e-07,
              6.0349378827596e-07,
              3.1512607279183e-07,
            },
          },
        },
      },
      water={  },
    },
    {
      label="Market rooms",
      lighting={
        ambient="CDB1D2FF",
        clifflightdirection={ 0.050000000745058, -1.2000000476837, 0.40000000596046,},
        clifflightweight=0.46200001239777,
        clifframp="ramp_toni",
        colorcube={ boss="startingforest_market_boss_cc", entrance="startingforest_market_cc",},
        ground_shadow_strength=0.75,
        rimlightcolor="D7A0F0FF",
        rimlightpos={ 30.0, 50.0, 50.0,},
      },
      room_types={ "market", "metaunlock",},
      sky={
        backgroundGradientCurve={
          boss={
            { 0, 0.74879229068756, 0.4557865858078, 0.4557865858078,},
            { 0.078189300411523, 0.34797218441963, 0.34278512001038, 0.52173912525177,},
            { 0.1358024691358, 0.2533991932869, 0.14623905718327, 0.31428569555283,},
            { 0.2202486678508, 0.092111632227898, 0.11219014972448, 0.23265308141708,},
            {
              0.39890710382514,
              9.9999999747524e-07,
              6.0349378827596e-07,
              3.1512607279183e-07,
            },
          },
          entrance={
            { 0, 0.90196079015732, 0.66666668653488, 0.44705882668495,},
            { 0.08641975308642, 0.40003505349159, 0.39524844288826, 0.56038647890091,},
            { 0.17695473251029, 0.28576299548149, 0.18823529779911, 0.34117648005486,},
            { 0.26593806921676, 0.14010308682919, 0.15850374102592, 0.26890754699707,},
            {
              0.39890710382514,
              9.9999999747524e-07,
              6.0349378827596e-07,
              3.1512607279183e-07,
            },
          },
        },
      },
      water={  },
    },
  },
  lighting=nil,
  particle_systems={
    {
      dungeon_progress_constraints={
        midway={ easing="linear", likelihood={ from=1, to=1,},},
        near_boss={ easing="linear", likelihood={ from=0.0, to=0.0,},},
        start_run={ easing="linear", likelihood={ from=1, to=1,},},
      },
      enabled=true,
      particle_system="dust_atmospheric_forge",
    },
    {
      dungeon_progress_constraints={
        midway={ easing="linear", likelihood={ from=0.0, to=0.0,},},
        near_boss={ easing="linear", likelihood={ from=1, to=1,},},
        start_run={ easing="linear", likelihood={ from=0.0, to=0.0,},},
      },
      enabled=true,
      particle_system="dust_atmospheric_forge_purple",
    },
  },
  rooms={
    "startingforest_arena_esw",
    "startingforest_arena_ew",
    "startingforest_arena_nesw",
    "startingforest_arena_new",
    "startingforest_arena_nsw",
    "startingforest_arena_nw",
    "startingforest_arena_sw",
    "startingforest_event_ew",
    "startingforest_large_esw",
    "startingforest_large_ew",
    "startingforest_large_nesw",
    "startingforest_large_new",
    "startingforest_large_nsw",
    "startingforest_large_nw",
    "startingforest_large_sw",
    "startingforest_megatreemon_boss_s",
    "startingforest_megatreemon_hype_ns",
    "startingforest_small_esw",
    "startingforest_small_ew",
    "startingforest_small_nesw",
    "startingforest_small_new",
    "startingforest_small_nsw",
    "startingforest_small_nw",
    "startingforest_small_sw",
    "startingforest_start_e",
    "startingforest_start_ne",
    "startingforest_start_s",
    "startingforest_start_n",
    "startingforest_miniboss_nesw",
    "startingforest_quest_nesw",
    "startingforest_market_nesw",
    "startingforest_metaunlock_nesw",
  },
  sky=nil,
  tier=1.0,
  tile_group="startingforest",
  underlay_props={
    {
      color_variants={  },
      dungeon_progress_constraints={
        midway={ easing="linear", likelihood={ from=1, to=1.0,},},
        near_boss={ easing="linear", likelihood={ from=0.0, to=0.0,},},
        start_run={ easing="linear", likelihood={ from=1, to=1,},},
      },
      enabled=true,
      prop="forest_bg_fillshrub",
    },
    {
      color_variants={  },
      dungeon_progress_constraints={
        midway={ easing="linear", likelihood={ from=0.0, to=0.0,},},
        near_boss={ easing="linear", likelihood={ from=1, to=1,},},
        start_run={ easing="linear", likelihood={ from=0.0, to=0.0,},},
      },
      enabled=true,
      prop="forest_bg_fillroot",
    },
  },
  water=nil,
  zone_gens={
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=37.0, hue=0.0, saturation=23.0,},
              likelihood=1.0,
              zones={ "near_bg",},
            },
            {
              color={ brightness=17, hue=15, saturation=16,},
              likelihood=1.0,
              zones={ "near_bg",},
            },
            {
              color={ brightness=44, hue=-18, saturation=25,},
              likelihood=1.0,
              zones={ "near_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="linear", likelihood={ from=0.25, to=0.10000000149012,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.2999999523163, count=5.0, height=0.0, radius=0.5,},
          prop="forest_bg_shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=18.0, hue=-7.0, saturation=-16.0,}, likelihood=1.0,},},
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="linear", likelihood={ from=0.25, to=0.25,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1, height=0, radius=0.5,},
          prop="forest_bg_fern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="forest_bg_deadfern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.25, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=0.89999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2.0, count=1, height=0, radius=0.69999998807907,},
          prop="forest_bg_deadroot",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0, hue=0, saturation=0,},
              likelihood=1,
              zones={ "bg", "near_side", "side", "near_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1, height=0, radius=0.5,},
          prop="forest_bg_deadtree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0, to=0.5,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1, height=0, radius=0.5,},
          prop="forest_bg_deadtree_mega",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.30000001192093, to=0.30000001192093,},},
            near_boss={ easing="linear", likelihood={ from=0.30000001192093, to=0.30000001192093,},},
            start_run={ easing="linear", likelihood={ from=0.30000001192093, to=0.30000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=0.5,},
          prop="forest_bg_lowshrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=1.0, to=1.0,},},
            near_boss={ easing="inSine", likelihood={ from=1.0, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0.25, to=1.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0.5, count=2, height=0, radius=0.5,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG1",
      zones={ "near_bg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="bg_trees",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-19.0, hue=10.0, saturation=7.0,},
              likelihood=100.0,
              zones={ "distant_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.34999999403954, to=0.89999997615814,},},
            near_boss={ easing="outExpo", likelihood={ from=0.89999997615814, to=1.0,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2.5, count=1, height=0, radius=1.5,},
          prop="forest_bg_tree_boss",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0.0, hue=0.0, saturation=0.0,},
              likelihood=100.0,
              zones={ "bg",},
            },
            {
              color={ brightness=-10, hue=0, saturation=0,},
              likelihood=100.0,
              zones={ "bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.64999997615814, to=0.10000000149012,},},
            near_boss={ easing="outExpo", likelihood={ from=0.10000000149012, to=0.0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.64999997615814,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2.5, count=1, height=0, radius=1.5,},
          prop="forest_bg_tree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="bg_trees",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG2",
      zones={ "bg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="bg_fill",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
      },
      scene_props={
        {
          color_variants={
            { color={ brightness=0, hue=0, saturation=0,}, likelihood=1.0, zones={ "bg",},},
            {
              color={ brightness=-22, hue=44, saturation=-16,},
              likelihood=1.0,
              zones={ "bg",},
            },
            {
              color={ brightness=18, hue=-18, saturation=-14,},
              likelihood=1.0,
              zones={ "bg",},
            },
            {
              color={ brightness=-3, hue=158, saturation=-47,},
              likelihood=0.5,
              zones={ "bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="linear", likelihood={ from=0.25, to=0.10000000149012,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=3, height=0, radius=1,},
          prop="forest_bg_shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0.0, hue=0.0, saturation=0.0,},
              likelihood=1.0,
              zones={ "bg", "near_side", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.2, to=0.2,},},
            near_boss={ easing="inSine", likelihood={ from=0.2, to=0.0,},},
            start_run={ easing="linear", likelihood={ from=0.2, to=0.2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="forest_bg_fern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="forest_bg_deadfern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0.0, hue=0.0, saturation=0.0,},
              likelihood=1.0,
              zones={ "bg", "near_side", "side", "near_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=1,},
          prop="forest_bg_deadtree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0, to=0.5,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=1,},
          prop="forest_bg_deadtree_mega",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.25, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=0.89999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="forest_bg_deadroot",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="bg_trees",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.25, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=0.89999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG3",
      zones={ "bg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="bg_fill_entrance_quest",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={ "entrance", "quest", "metaunlock",},
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-12, hue=-6, saturation=0,},
              likelihood=1,
              zones={ "bg", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.10000000149012, to=0.0,},},
            near_boss={ easing="outSine", likelihood={ from=0.0, to=0.0,},},
            start_run={ easing="inQuint", likelihood={ from=0.25, to=0.10000000149012,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="forest_bg_ruins",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            { color={ brightness=0, hue=0, saturation=0,}, likelihood=1, zones={ "bg",},},
            { color={ brightness=-22, hue=44, saturation=-16,}, likelihood=1, zones={ "bg",},},
            { color={ brightness=18, hue=-18, saturation=-14,}, likelihood=1, zones={ "bg",},},
            {
              color={ brightness=-3, hue=158, saturation=-47,},
              likelihood=0.5,
              zones={ "bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="linear", likelihood={ from=0.25, to=0.10000000149012,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=3.0, height=0, radius=1,},
          prop="forest_bg_shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0, hue=0, saturation=0,},
              likelihood=1,
              zones={ "bg", "near_side", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.2, to=0.2,},},
            near_boss={ easing="inSine", likelihood={ from=0.2, to=0,},},
            start_run={ easing="linear", likelihood={ from=0.2, to=0.2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=2.0, height=0, radius=1,},
          prop="forest_bg_fern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="forest_bg_deadfern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0, hue=0, saturation=0,},
              likelihood=1,
              zones={ "bg", "near_side", "side", "near_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=1,},
          prop="forest_bg_deadtree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0, to=0.5,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=1,},
          prop="forest_bg_deadtree_mega",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.25, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=0.89999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="forest_bg_deadroot",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-38.0, hue=-6, saturation=0,},
              likelihood=1,
              zones={ "bg", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.10000000149012, to=0.25,},},
            near_boss={ easing="inSine", likelihood={ from=0.25, to=0.25,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.10000000149012,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="forest_bg_ruins_dark",
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="forest_bg_ruins",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="bg_trees",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.25, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=0.89999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG4",
      zones={ "bg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="distant_bg_trees",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-17, hue=17.0, saturation=14.0,},
              likelihood=100.0,
              zones={ "distant_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.64999997615814, to=0.10000000149012,},},
            near_boss={ easing="outExpo", likelihood={ from=0.10000000149012, to=0.0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.64999997615814,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3, count=1, height=0, radius=1.5,},
          prop="forest_bg_tree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-19, hue=10, saturation=7,},
              likelihood=100,
              zones={ "distant_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.34999999403954, to=0.89999997615814,},},
            near_boss={ easing="outExpo", likelihood={ from=0.89999997615814, to=1.0,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3, count=1, height=0, radius=1.5,},
          prop="forest_bg_tree_boss",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="distant_bg_trees",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG5",
      zones={ "distant_bg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="distant_bg_fill",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-12, hue=167, saturation=-9,},
              likelihood=1.0,
              zones={ "distant_bg",},
            },
            {
              color={ brightness=-4, hue=54, saturation=4,},
              likelihood=1.0,
              zones={ "distant_bg",},
            },
            {
              color={ brightness=0, hue=19, saturation=0,},
              likelihood=1.0,
              zones={ "distant_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="linear", likelihood={ from=0.25, to=0.10000000149012,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=3, height=0, radius=0.5,},
          prop="forest_bg_shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-22.0, hue=-17.0, saturation=-13.0,},
              likelihood=1.0,
              zones={ "distant_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.2, to=0.2,},},
            near_boss={ easing="inSine", likelihood={ from=0.2, to=0,},},
            start_run={ easing="linear", likelihood={ from=0.2, to=0.2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=0.5,},
          prop="forest_bg_fern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-18.0, hue=0, saturation=6.0,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=0.5,},
          prop="forest_bg_deadfern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-16.0, hue=-9.0, saturation=-1.0,},
              likelihood=1.0,
              zones={ "distant_bg", "distant_side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=1,},
          prop="forest_bg_deadtree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="forest_bg_deadtree_mega",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-17.0, hue=14.0, saturation=12.0,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.25, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=0.89999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="forest_bg_deadroot",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="distant_bg_trees",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.25, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=0.89999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG6",
      zones={ "distant_bg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.25, to=0.75,},},
            near_boss={ easing="outCubic", likelihood={ from=0.75, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0.0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2, count=1, height=0, radius=1,},
          prop="forest_bg_fartree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="outCubic", likelihood={ from=0.25, to=0.0,},},
            start_run={ easing="inQuint", likelihood={ from=1.0, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=2, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG7",
      zones={ "near_underlay",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-12.0, hue=51.0, saturation=0,},
              likelihood=1,
              zones={ "near_bg",},
            },
            { color={ brightness=0, hue=0, saturation=0,}, likelihood=1, zones={ "near_bg",},},
            {
              color={ brightness=17.0, hue=15.0, saturation=16.0,},
              likelihood=1,
              zones={ "near_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="linear", likelihood={ from=0.25, to=0.10000000149012,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=5, height=0, radius=1.1000000238419,},
          prop="forest_bg_shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.25, count=1, height=0, radius=0.25,},
          prop="forest_bg_lowshrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="linear", likelihood={ from=0.25, to=0.25,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.30000001192093, count=1, height=0, radius=0.69999998807907,},
          prop="forest_bg_fern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=0.69999998807907,},
          prop="forest_bg_deadfern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0, hue=0, saturation=0,},
              likelihood=1,
              zones={ "bg", "near_side", "side", "near_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=1.2000000476837,},
          prop="forest_bg_deadtree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=1.2000000476837,},
          prop="forest_bg_deadtree_mega",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG8",
      zones={ "near_side",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="side_trees",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-13, hue=3, saturation=-15,},
              likelihood=100,
              zones={ "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.64999997615814, to=0.10000000149012,},},
            near_boss={ easing="outExpo", likelihood={ from=0.10000000149012, to=0.0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.64999997615814,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=4, count=1, height=0, radius=1.5,},
          prop="forest_bg_tree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-27, hue=12, saturation=14,},
              likelihood=68.353996276855,
              zones={ "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.34999999403954, to=0.89999997615814,},},
            near_boss={ easing="outExpo", likelihood={ from=0.89999997615814, to=1.0,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3, count=1, height=0, radius=1.5,},
          prop="forest_bg_tree_boss",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="side_trees",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG9",
      zones={ "side",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="side_fill",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=0.5,},
          prop="forest_bg_lowshrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-28, hue=23, saturation=-9,},
              likelihood=1.0,
              zones={ "side",},
            },
            {
              color={ brightness=-29, hue=106, saturation=-27,},
              likelihood=1.0,
              zones={ "side",},
            },
            {
              color={ brightness=-22, hue=44, saturation=-16,},
              likelihood=1.0,
              zones={ "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="linear", likelihood={ from=0.25, to=0.10000000149012,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=0.5,},
          prop="forest_bg_shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0.0, hue=0.0, saturation=0.0,},
              likelihood=1.0,
              zones={ "bg", "near_side", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.2, to=0.2,},},
            near_boss={ easing="inSine", likelihood={ from=0.2, to=0,},},
            start_run={ easing="linear", likelihood={ from=0.2, to=0.2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=0.5,},
          prop="forest_bg_fern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0.0, hue=0.0, saturation=0.0,},
              likelihood=1.0,
              zones={ "near_bg", "bg", "near_side", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=0.5,},
          prop="forest_bg_deadfern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0.0, hue=0.0, saturation=0.0,},
              likelihood=1.0,
              zones={ "bg", "near_side", "side", "near_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=1,},
          prop="forest_bg_deadtree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0.0, to=1.0,},},
            start_run={ easing="linear", likelihood={ from=0, to=0.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="forest_bg_deadtree_mega",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0.0, hue=0.0, saturation=0.0,},
              likelihood=1.0,
              zones={ "near_fg", "near_side", "side", "bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.25, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=0.89999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2, count=1, height=0, radius=1,},
          prop="forest_bg_deadroot",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="side_trees",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.25, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=0.89999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG10",
      zones={ "side",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="side_fill_entrance_quest",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={ "entrance", "quest", "metaunlock",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=0.5,},
          prop="forest_bg_lowshrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-28, hue=23, saturation=-9,},
              likelihood=1,
              zones={ "side",},
            },
            {
              color={ brightness=-29, hue=106, saturation=-27,},
              likelihood=1,
              zones={ "side",},
            },
            {
              color={ brightness=-22, hue=44, saturation=-16,},
              likelihood=1,
              zones={ "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="linear", likelihood={ from=0.25, to=0.10000000149012,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=0.5,},
          prop="forest_bg_shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0, hue=0, saturation=0,},
              likelihood=1,
              zones={ "bg", "near_side", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.2, to=0.2,},},
            near_boss={ easing="inSine", likelihood={ from=0.2, to=0,},},
            start_run={ easing="linear", likelihood={ from=0.2, to=0.2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=0.5,},
          prop="forest_bg_fern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0, hue=0, saturation=0,},
              likelihood=1,
              zones={ "near_bg", "bg", "near_side", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=0.5,},
          prop="forest_bg_deadfern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0, hue=0, saturation=0,},
              likelihood=1,
              zones={ "bg", "near_side", "side", "near_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=1,},
          prop="forest_bg_deadtree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="forest_bg_deadtree_mega",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0, hue=0, saturation=0,},
              likelihood=1,
              zones={ "near_fg", "near_side", "side", "bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.25, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=0.89999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2, count=1, height=0, radius=1,},
          prop="forest_bg_deadroot",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-12, hue=-6, saturation=0,},
              likelihood=1,
              zones={ "bg", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.10000000149012, to=0,},},
            near_boss={ easing="outSine", likelihood={ from=0, to=0,},},
            start_run={ easing="inQuint", likelihood={ from=0.25, to=0.10000000149012,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=2.0, height=0, radius=1,},
          prop="forest_bg_ruins",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-38, hue=-6, saturation=0,},
              likelihood=1,
              zones={ "bg", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.10000000149012, to=0.25,},},
            near_boss={ easing="inSine", likelihood={ from=0.25, to=0.25,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.10000000149012,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="forest_bg_ruins_dark",
          placement={ buffer=1, count=2.0, height=0, radius=1,},
          prop="forest_bg_ruins",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="side_trees",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.25, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=0.89999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG11",
      zones={ "side",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="distant_side_trees",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-40, hue=3, saturation=-7,},
              likelihood=100,
              zones={ "distant_side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.64999997615814, to=0.10000000149012,},},
            near_boss={ easing="outExpo", likelihood={ from=0.10000000149012, to=0.0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.64999997615814,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3, count=1, height=0, radius=1.5,},
          prop="forest_bg_tree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-42, hue=23, saturation=14,},
              likelihood=100,
              zones={ "distant_side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.34999999403954, to=0.89999997615814,},},
            near_boss={ easing="outExpo", likelihood={ from=0.89999997615814, to=1.0,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3, count=1, height=0, radius=1.5,},
          prop="forest_bg_tree_boss",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="distant_side_trees",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG12",
      zones={ "distant_side",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="distant_side_fill",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-33, hue=10, saturation=-11,},
              likelihood=1.0,
              zones={ "distant_side",},
            },
            {
              color={ brightness=-41.0, hue=37.0, saturation=-9.0,},
              likelihood=1.0,
              zones={ "distant_side",},
            },
            {
              color={ brightness=-43, hue=167, saturation=-9,},
              likelihood=1.0,
              zones={ "distant_side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="linear", likelihood={ from=0.25, to=0.10000000149012,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=0.5,},
          prop="forest_bg_shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=0.5,},
          prop="forest_bg_lowshrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0, hue=0, saturation=0,},
              likelihood=1,
              zones={ "bg", "near_side", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.2, to=0.2,},},
            near_boss={ easing="inSine", likelihood={ from=0.2, to=0,},},
            start_run={ easing="linear", likelihood={ from=0.2, to=0.2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=0.5,},
          prop="forest_bg_fern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-18, hue=0, saturation=6,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=0.5,},
          prop="forest_bg_deadfern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-16.0, hue=-9.0, saturation=-1.0,},
              likelihood=1.0,
              zones={ "distant_bg", "distant_side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=1,},
          prop="forest_bg_deadtree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0.0, to=1.0,},},
            start_run={ easing="linear", likelihood={ from=0, to=0.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="forest_bg_deadtree_mega",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-18.0, hue=0, saturation=6.0,},
              likelihood=1,
              zones={ "near_fg", "near_side", "side", "bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.25, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=0.89999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2, count=1, height=0, radius=1,},
          prop="forest_bg_deadroot",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="distant_side_trees",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.25, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=0.89999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG13",
      zones={ "distant_side",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=0.0, hue=0.0, saturation=0.0,},
              likelihood=1.0,
              zones={ "fg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.64999997615814, to=0.0010000000474975,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.64999997615814,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=0.5,},
          prop="forest_fg_fern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=0, hue=0, saturation=0,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=0.5,},
          prop="forest_fg_deadfern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0.0, hue=0.0, saturation=0.0,},
              likelihood=1.0,
              zones={ "near_fg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.64999997615814, to=0.0010000000474975,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.64999997615814,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.5, count=1, height=0, radius=0.80000001192093,},
          prop="forest_fg_shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=0, hue=0, saturation=0,},
              likelihood=1,
              zones={ "fg_side", "distant_fg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.5, count=1, height=0, radius=0.8,},
          prop="forest_fg_deadshrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2, count=1, height=0, radius=0.8,},
          prop="forest_fg_deadtree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2, count=1, height=0, radius=0.8,},
          prop="forest_fg_deadtree_mega",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0, to=0.30000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.30000001192093, to=0.80000001192093,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2, count=1, height=0, radius=0.8,},
          prop="forest_fg_root",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=0.5,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG14",
      zones={ "near_fg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-33.0, hue=-8.0, saturation=-22.0,},
              likelihood=1.0,
              zones=nil,
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.64999997615814, to=0,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.64999997615814,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1, height=0, radius=1,},
          prop="forest_fg_fern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-33, hue=-8, saturation=-22,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1, height=0, radius=1,},
          prop="forest_fg_deadfern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            { color={ brightness=-33, hue=-8, saturation=-22,}, likelihood=1, zones={ "fg",},},
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.64999997615814, to=0.0010000000474975,},},
            near_boss={ easing="linear", likelihood={ from=0.0, to=0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.64999997615814,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, height=0, radius=1.0,},
          prop="forest_fg_shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-33, hue=-8, saturation=-22,},
              likelihood=1,
              zones={ "fg_side", "distant_fg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, height=0, radius=1.0,},
          prop="forest_fg_deadshrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.5, height=0, radius=1.2000000476837,},
          prop="forest_fg_deadtree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.5, height=0, radius=1.2000000476837,},
          prop="forest_fg_deadtree_mega",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.0, to=0.30000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.30000001192093, to=0.80000001192093,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2.0, count=1, height=0, radius=1,},
          prop="forest_fg_root",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.25, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=0.89999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG15",
      zones={ "fg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-33.0, hue=-8.0, saturation=-22.0,},
              likelihood=1.0,
              zones={ "fg_side", "distant_fg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.64999997615814, to=0,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.64999997615814,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, height=0, radius=1.5,},
          prop="forest_fg_fern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          buffer=0,
          color_variants={ { color={ brightness=-33, hue=-8, saturation=-22,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1.5,},
          prop="forest_fg_deadfern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-33.0, hue=-8.0, saturation=-22.0,},
              likelihood=1.0,
              zones={ "fg_side", "distant_fg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.64999997615814, to=0.0010000000474975,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.64999997615814,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2.0, height=0, radius=0.80000001192093,},
          prop="forest_fg_shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-33, hue=-8, saturation=-22,},
              likelihood=1,
              zones={ "fg_side", "distant_fg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2.0, count=1, height=0, radius=0.80000001192093,},
          prop="forest_fg_deadshrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.5, count=1, height=0, radius=1.2000000476837,},
          prop="forest_fg_deadtree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0.0, to=1.0,},},
            start_run={ easing="linear", likelihood={ from=0, to=0.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.5, count=1, height=0, radius=1.2000000476837,},
          prop="forest_fg_deadtree_mega",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0, to=0.30000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.30000001192093, to=0.80000001192093,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2.0, count=1, height=0, radius=1,},
          prop="forest_fg_root",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.25, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=0.89999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG16",
      zones={ "distant_fg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Ground: fg_size-tree",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.64999997615814, to=0.0010000000474975,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.64999997615814,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={ "required",},
          placement={ buffer=6.0, height=0, radius=1,},
          prop="forest_fg_tree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={ "required",},
          placement={ buffer=6.0, count=1, height=0, radius=1,},
          prop="forest_fg_holetree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.25, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=0.89999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG17",
      zones={ "fg_side",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.64999997615814, to=0.0010000000474975,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.64999997615814,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={ "required",},
          placement={ buffer=1.0, height=0, radius=1.0,},
          prop="forest_fg_tree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={ "required",},
          placement={ buffer=1.0, count=1, height=0, radius=1.0,},
          prop="forest_fg_holetree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-33.0, hue=-8.0, saturation=-22.0,},
              likelihood=1.0,
              zones=nil,
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.64999997615814, to=0,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.64999997615814,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, height=0, radius=0.5,},
          prop="forest_fg_fern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-33.0, hue=-8.0, saturation=-22.0,}, likelihood=1.0,},},
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1, height=0, radius=0.5,},
          prop="forest_fg_deadfern",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-33.0, hue=-8.0, saturation=-22.0,},
              likelihood=1.0,
              zones=nil,
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.64999997615814, to=0.0010000000474975,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.64999997615814,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2.0, count=2.0, height=0, radius=0.5,},
          prop="forest_fg_shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-33, hue=-8, saturation=-22,},
              likelihood=1,
              zones={ "fg_side", "distant_fg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2.0, count=2, height=0, radius=0.5,},
          prop="forest_fg_deadshrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1, height=0, radius=1.0,},
          prop="forest_fg_deadtree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inCubic", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1, height=0, radius=1.0,},
          prop="forest_fg_deadtree_mega",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0, to=0.30000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.30000001192093, to=0.80000001192093,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1, height=0, radius=0.5,},
          prop="forest_fg_root",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.25, to=0.80000001192093,},},
            near_boss={ easing="inSine", likelihood={ from=0.80000001192093, to=0.89999997615814,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG18",
      zones={ "fg_side",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Physics: non_walkable_bg",
      non_walkable=true,
      offstage=false,
      particle_systems={  },
      room_types={ "boss", "empty", "insert", "miniboss", "monster",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.80000001192093, to=0,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.2000000476837, count=1, height=0, radius=0.80000001192093,},
          prop="tree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.20000000298023, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.2000000476837, count=1, height=0, radius=0.80000001192093,},
          prop="forest_grid_deadtree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="nodouble",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          height=0,
          placement={ buffer=1.0, count=5.0, height=0, radius=1.0,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0.5, count=5.0, height=0, radius=0.5,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG19",
      zones={ "non_walkable_bg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Physics: non_walkable_bg_fg",
      non_walkable=true,
      offstage=false,
      particle_systems={  },
      room_types={ "boss", "empty", "insert", "miniboss", "monster",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=8.0, height=0, radius=0.15000000596046,},
          prop="forest_grid_tallgrass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.25, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=8.0, height=0, radius=0.15000000596046,},
          prop="forest_grid_deadtallgrass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          height=0,
          placement={ buffer=1.0, count=6.0, height=0, radius=0.15000000596046,},
          prop="forest_grid_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.25, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1.0,},},
            start_run={ easing="inQuint", likelihood={ from=0.0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=6.0, height=0, radius=0.15000000596046,},
          prop="forest_grid_deadgrass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.69999998807907, count=1, height=0, radius=0.30000001192093,},
          prop="flower_bush",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.69999998807907, count=1, height=0, radius=0.30000001192093,},
          prop="flower_violet",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          height=0,
          placement={ buffer=0.5, count=2.0, height=0, radius=0.30000001192093,},
          prop="forest_grid_deadflower",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.80000001192093, to=0,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=2.0, height=0, radius=0.5,},
          prop="shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.20000000298023, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=2.0, height=0, radius=0.5,},
          prop="shrub_dying",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="nodouble",
      spacers={  },
      tag="ZONE_GEN_TAG20",
      zones={ "non_walkable_fg", "non_walkable_bg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="inside_perimeter_arena",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "empty", "insert", "miniboss", "monster",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.80000001192093, to=0,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.0, count=4, height=0, radius=1.0,},
          prop="shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.20000000298023, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=4, height=0, radius=1,},
          prop="shrub_dying",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.0, count=2, height=0, radius=1.0,},
          prop="flower_bush",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.0, count=2, height=0, radius=1.0,},
          prop="flower_violet",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=4, height=0, radius=1,},
          prop="forest_grid_deadflower",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=8, height=0, radius=0.75,},
          prop="forest_grid_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.25, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1.0,},},
            start_run={ easing="inQuint", likelihood={ from=0.0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=8, height=0, radius=0.75,},
          prop="forest_grid_deadgrass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=0.5,},
          prop="decor_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          height=0,
          placement={ buffer=0, count=2, height=0, radius=0.5,},
          prop="forest_floor_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0.75, count=5.0, height=0, radius=0.5,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG21",
      zones={ "inside_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="inside_perimeter_entrance_tree",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "entrance", "quest", "metaunlock",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1.0, to=1,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={ "tall",},
          placement={ buffer=2, count=2, height=0, radius=1,},
          prop="tree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="entrance_tree",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=4.0, height=0, radius=1.9,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG22",
      zones={ "inside_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="inside_perimeter_entr/quest_fill",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "entrance", "quest",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=0.5,},
          prop="forest_floor_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.0, count=2, height=0, radius=1.0,},
          prop="flower_bush",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.0, count=2, height=0, radius=1.0,},
          prop="flower_violet",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.80000001192093, to=0,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.0, count=5.0, height=0, radius=1.0,},
          prop="shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="entrance_tree",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=3, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=3, height=0, radius=1.9,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG23",
      zones={ "inside_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="front_perimeter_arena",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "insert", "miniboss", "empty", "monster",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.80000001192093, to=0,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.0, count=1, height=0, radius=1.0,},
          prop="shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.20000000298023, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="shrub_dying",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.0, count=1, height=0, radius=1.0,},
          prop="flower_bush",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="flower_violet",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="forest_grid_deadflower",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="forest_grid_deadflower",
          tile_type_filter_shape="Point",
          tile_types={ "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=0.5,},
          prop="forest_floor_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=0.75,},
          prop="forest_grid_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.25, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1.0,},},
            start_run={ easing="inQuint", likelihood={ from=0.0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=0.75,},
          prop="forest_grid_deadgrass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="decor_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG24",
      zones={ "front_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="front_perimeter_entr/quest",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "entrance", "quest",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="forest_floor_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.0, count=1.0, height=0, radius=1.0,},
          prop="flower_bush",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.0, count=1.0, height=0, radius=1.0,},
          prop="flower_violet",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          buffer=0,
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.80000001192093, to=0,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.0, count=3.0, height=0, radius=1.0,},
          prop="shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=3.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG25",
      zones={ "front_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="middle_entrance_tree",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "entrance",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="destructible_wood_shorty",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="destructible_wood_tall",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="middle_entrance_tree",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=4, height=0, radius=3,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=5, height=0, radius=2,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG26",
      zones={ "middle",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="middle_quest_tree",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "quest",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="destructible_wood_shorty",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="destructible_wood_tall",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="middle_entrance_tree",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=6.0, height=0, radius=3,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=8.0, height=0, radius=2,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=5.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG27",
      zones={ "middle",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="middle_entrance_fill",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "entrance", "quest",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="decor_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="forest_floor_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="middle_entrance_tree",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=6, height=0, radius=3,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=7, height=0, radius=2,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=6.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG28",
      zones={ "middle",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="middle_arena",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "empty", "insert", "miniboss", "monster",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=5, height=0, radius=0.75,},
          prop="forest_grid_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.25, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1.0,},},
            start_run={ easing="inQuint", likelihood={ from=0.0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=5, height=0, radius=0.75,},
          prop="forest_grid_deadgrass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="decor_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=2, height=0, radius=1,},
          prop="spawner_plant1_med",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="spawner_plant1_sml",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=5.0, height=0, radius=3,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=10, height=0, radius=2,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=10.0, height=0, radius=1.5,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=5.0, height=0, radius=4,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG29",
      zones={ "middle",},
    },
    {
      can_obscure_features=true,
      decor_layer="Canopy",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="inBack", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=0.5,},
          prop="forest_up_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="inBack", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="forest_up_canopy_higher",
          placement={ buffer=1, count=1, height=2.5, radius=0.5,},
          prop="forest_up_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.25, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1,},},
            start_run={ easing="inBack", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=2.5, radius=1.5,},
          prop="forest_up_deadcanopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.25, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1,},},
            start_run={ easing="inBack", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1.5,},
          prop="forest_up_deadcanopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG30",
      zones={ "near_bg",},
    },
    {
      can_obscure_features=true,
      decor_layer="Canopy",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          buffer=1.0,
          color_variants={
            {
              color={ brightness=-21.0, hue=0, saturation=-10.0,},
              likelihood=1,
              zones={ "bg", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="inBack", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=2, height=0, radius=0.5,},
          prop="forest_up_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-21, hue=0, saturation=-10,},
              likelihood=1,
              zones={ "bg", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0.0,},},
            start_run={ easing="inBack", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="forest_up_canopy_higher",
          placement={ buffer=1, count=1, height=4, radius=0.5,},
          prop="forest_up_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-21, hue=0, saturation=-10,},
              likelihood=1,
              zones={ "bg", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.25, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1,},},
            start_run={ easing="inBack", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="forest_up_deadcanopy_higher",
          placement={ buffer=0, count=1, height=4, radius=1.5,},
          prop="forest_up_deadcanopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-21, hue=0, saturation=-10,},
              likelihood=1,
              zones={ "bg", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.25, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1,},},
            start_run={ easing="inBack", likelihood={ from=0.0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=2, height=0, radius=1.5,},
          prop="forest_up_deadcanopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG31",
      zones={ "bg",},
    },
    {
      can_obscure_features=true,
      decor_layer="Canopy",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="inBack", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1.0, height=0, radius=0.5,},
          prop="forest_up_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="inBack", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="forest_up_canopy_higher",
          placement={ buffer=1, count=1.0, height=3, radius=0.5,},
          prop="forest_up_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.25, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1,},},
            start_run={ easing="inBack", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1.0, height=0, radius=1.5,},
          prop="forest_up_deadcanopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.25, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1,},},
            start_run={ easing="inBack", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="forest_up_deadcanopy_higher",
          placement={ buffer=0, count=1, height=3, radius=1.5,},
          prop="forest_up_deadcanopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG32",
      zones={ "near_side",},
    },
    {
      can_obscure_features=true,
      decor_layer="Canopy",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-21, hue=0, saturation=-10,},
              likelihood=1,
              zones={ "bg", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="inBack", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=2, height=0, radius=0.5,},
          prop="forest_up_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-21, hue=0, saturation=-10,},
              likelihood=1,
              zones={ "bg", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="inBack", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="forest_up_canopy_higher",
          placement={ buffer=1, count=1, height=4, radius=0.5,},
          prop="forest_up_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-21, hue=0, saturation=-10,},
              likelihood=1,
              zones={ "bg", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.25, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1,},},
            start_run={ easing="inBack", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="forest_up_deadcanopy_higher",
          placement={ buffer=0, count=1, height=4, radius=1.5,},
          prop="forest_up_deadcanopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=-21, hue=0, saturation=-10,},
              likelihood=1,
              zones={ "bg", "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.25, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1,},},
            start_run={ easing="inBack", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=2, height=0, radius=1.5,},
          prop="forest_up_deadcanopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG33",
      zones={ "side",},
    },
    {
      can_obscure_features=true,
      decor_layer="Canopy",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="inBack", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1.0, height=0, radius=0.5,},
          prop="forest_fg_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="inBack", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="forest_fg_canopy_higher",
          placement={ buffer=1.0, count=1.0, height=3.0, radius=0.5,},
          prop="forest_fg_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.25, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1,},},
            start_run={ easing="inBack", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1.0, height=0, radius=0.5,},
          prop="forest_fg_deadcanopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.25, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1.0,},},
            start_run={ easing="inBack", likelihood={ from=0.0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="forest_fg_deadcanopy_higher",
          placement={ buffer=1.0, count=1.0, height=3.0, radius=0.5,},
          prop="forest_fg_deadcanopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="inBack", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="forest_fg_canopy_higher2",
          placement={ buffer=1.0, count=1.0, height=7.0, radius=1.0,},
          prop="forest_fg_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.25, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1,},},
            start_run={ easing="inBack", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="forest_fg_deadcanopy_higher2",
          placement={ buffer=1.0, count=1.0, height=7.0, radius=1.0,},
          prop="forest_fg_deadcanopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG34",
      zones={ "fg_side",},
    },
    {
      can_obscure_features=true,
      decor_layer="Shadow",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=5.0, count=1, height=0, radius=0.5,},
          prop="canopy_shadow",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG35",
      zones={ "near_side", "near_bg", "near_fg",},
    },
    {
      can_obscure_features=true,
      decor_layer="Shadow",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.25, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1,},},
            start_run={ easing="inBack", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=4.0, count=1, height=0, radius=1.0,},
          prop="canopy_shadow",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.80000001192093, to=0.5,},},
            near_boss={ easing="outSine", likelihood={ from=0.5, to=0.25,},},
            start_run={ easing="inBack", likelihood={ from=1, to=0.80000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=4.0, count=3, height=0, radius=1.0,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG36",
      zones={ "front_perimeter", "inside_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="inside_perimeter_metaunlock",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "metaunlock",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.80000001192093, to=0,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=4, height=0, radius=1,},
          prop="shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.20000000298023, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=4, height=0, radius=1,},
          prop="shrub_dying",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=2, height=0, radius=1,},
          prop="flower_bush",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=2, height=0, radius=1,},
          prop="flower_violet",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=4, height=0, radius=1,},
          prop="forest_grid_deadflower",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=10.0, height=0, radius=0.75,},
          prop="forest_grid_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.25, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=8, height=0, radius=0.75,},
          prop="forest_grid_deadgrass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0.75, count=3.0, height=0, radius=0.5,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG37",
      zones={ "inside_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="front_perimeter_metaunlock",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "metaunlock",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.80000001192093, to=0,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="shrub",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outQuad", likelihood={ from=0.20000000298023, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="shrub_dying",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="flower_bush",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="flower_violet",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="forest_grid_deadflower",
          tile_type_filter_shape="Point",
          tile_types={ "rough", "path",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="forest_grid_deadflower",
          tile_type_filter_shape="Point",
          tile_types={ "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=0.5,},
          prop="forest_floor_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.75, to=0.25,},},
            near_boss={ easing="outSine", likelihood={ from=0.25, to=0,},},
            start_run={ easing="inQuint", likelihood={ from=1, to=0.75,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=2.0, height=0, radius=0.75,},
          prop="forest_grid_grass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.25, to=0.75,},},
            near_boss={ easing="outSine", likelihood={ from=0.75, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.25,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=2.0, height=0, radius=0.75,},
          prop="forest_grid_deadgrass",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="decor_rock",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG38",
      zones={ "front_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="middle_metaunlock_tree",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "metaunlock",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="destructible_wood_shorty",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="destructible_wood_tall",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=2.0, height=0, radius=1,},
          prop="forest_grid_grass",
          tile_type_filter_shape="Point",
        },
      },
      seed="middle_entrance_tree",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1.0, height=0, radius=3,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=2.0, height=0, radius=2,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=3.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG39",
      zones={ "middle",},
    },
  },
}
t.lighting = t.environments[1].lighting
t.sky = t.environments[1].sky
t.water = t.environments[1].water
t.zone_gens[15].scene_props[1].color_variants[1].zones = t.zone_gens[14].scene_props[1].color_variants[1].zones
t.zone_gens[18].scene_props[3].color_variants[1].zones = t.zone_gens[16].scene_props[1].color_variants[1].zones
t.zone_gens[18].scene_props[5].color_variants[1].zones = t.zone_gens[16].scene_props[3].color_variants[1].zones
return t
